<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
		
	<xsl:template match="/motelmateResult">

		<FMPXMLRESULT xmlns="http://www.filemaker.com/fmpxmlresult">
			<ERRORCODE>0</ERRORCODE>
			<PRODUCT BUILD="" NAME="" VERSION=""/>
			<DATABASE DATEFORMAT="" LAYOUT="" NAME="" RECORDS="{sum(provider/booking/room/@count) + count(provider/@message)}" TIMEFORMAT=""/>

			<METADATA>
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Provider" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Result" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Mode" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="ReservationID" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="ReservationDateTime" TYPE="TEXT" />
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="RoomType" TYPE="NUMBER" />
				
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Guests" TYPE="NUMBER" />
				<!--<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Child" TYPE="NUMBER" /> -->
				<!--<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="RoomCount" TYPE="NUMBER" />-->
				<FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="DateIn" TYPE="DATE" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="DateOut" TYPE="DATE" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerFirstName" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerSurname" TYPE="TEXT" />
        
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerTelephone" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerFax" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerMobile" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerEmail" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CustomerAddress" TYPE="TEXT" />
        
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="PriceTotal" TYPE="NUMBER" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Comment" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="Agent" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CardName" TYPE="TEXT" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CardNumber" TYPE="TEXT" />
        
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CardMonth" TYPE="NUMBER" />
        <FIELD EMPTYOK="YES" MAXREPEAT="1" NAME="CardYear" TYPE="NUMBER" />
			</METADATA>

			<RESULTSET>
				<xsl:attribute name="FOUND"><xsl:value-of select="sum(provider/booking/room/@count) + count(provider/@message)"/></xsl:attribute>
	
				<!-- NOTE: ReservationDateTime, DateIn, DateOut
							 are formatted into FileMaker's preferred timestamp format (dd/MM/yyyy HH:mm:ss for AU/NZ)
							 using string manipulation functions -->
	
				<xsl:for-each select="provider">
					<xsl:choose>
						<xsl:when test="@message"> <!-- Error Message -->
							<ROW MODID="0" RECORDID="0">
								<COL><DATA><xsl:value-of select="@name"/></DATA></COL>
								<COL><DATA>Error: <xsl:value-of select="@message"/></DATA></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								<COL><DATA /></COL>
								
								<COL><DATA /></COL>
								<COL><DATA /></COL>
							</ROW>
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="booking">
								<xsl:for-each select="room">
									
									<xsl:call-template name="bookings">
										<xsl:with-param name="Provider"><xsl:value-of select="../../@name" /></xsl:with-param>
										<xsl:with-param name="Result"><xsl:value-of select="../../@result" /></xsl:with-param>
										<xsl:with-param name="Mode"><xsl:value-of select="../@mode" /></xsl:with-param>
										<xsl:with-param name="ReservationID"><xsl:value-of select="../@id" /></xsl:with-param>
										<xsl:with-param name="ReservationDateTime"><xsl:value-of select="../@at" /></xsl:with-param>
										<xsl:with-param name="RoomType"><xsl:value-of select="@type" /></xsl:with-param>
										<xsl:with-param name="FullCount"><xsl:value-of select="@count" /></xsl:with-param>
										<xsl:with-param name="RoomCount"><xsl:value-of select="@count" /></xsl:with-param>
										<xsl:with-param name="Adult"><xsl:value-of select="format-number((../guests/@adult + ../guests/@child) div sum(../room/@count), '#,##0.##')" /></xsl:with-param>
										<!-- <xsl:with-param name="Child"><xsl:value-of select="../guests/@child" /></xsl:with-param> -->
										<xsl:with-param name="DateIn"><xsl:value-of select="substring(../timespan/@start,'9','2')"/>/<xsl:value-of select="substring(../timespan/@start,'6','2')"/>/<xsl:value-of select="substring(../timespan/@start,'1','4')" /></xsl:with-param>
										<xsl:with-param name="DateOut"><xsl:value-of select="substring(../timespan/@end,'9','2')"/>/<xsl:value-of select="substring(../timespan/@end,'6','2')"/>/<xsl:value-of select="substring(../timespan/@end,'1','4')" /></xsl:with-param>
										<xsl:with-param name="CustomerFirstName"><xsl:value-of select="../customer/name/@first" /></xsl:with-param>
										<xsl:with-param name="CustomerSurname"><xsl:value-of select="../customer/name/@last" /></xsl:with-param>
										<xsl:with-param name="CustomerTelephone"><xsl:value-of select="../customer/contact/@phone" /></xsl:with-param>
										<xsl:with-param name="CustomerFax"><xsl:value-of select="../customer/contact/@fax" /></xsl:with-param>
										<xsl:with-param name="CustomerMobile"><xsl:value-of select="../customer/contact/@mobile" /></xsl:with-param>
										<xsl:with-param name="CustomerEmail"><xsl:value-of select="../customer/contact/@email" /></xsl:with-param>
										<xsl:with-param name="CustomerAddress"><xsl:value-of select="../customer/address" /></xsl:with-param>
										<xsl:with-param name="PriceTotal">
										<xsl:choose>
											<xsl:when test="@total">
												<xsl:value-of select="@total div @count" />
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="../price/@total div sum(../room/@count)" />
											</xsl:otherwise>
										</xsl:choose>
										</xsl:with-param>
										<xsl:with-param name="Comment"><xsl:value-of select="../comment" /></xsl:with-param>
										<xsl:with-param name="Agent"><xsl:value-of select="../@agent" /></xsl:with-param>
										<xsl:with-param name="CardName"><xsl:value-of select="../card/@name" /></xsl:with-param>
										<xsl:with-param name="CardNumber"><xsl:value-of select="../card/@number" /></xsl:with-param>
										<xsl:with-param name="CardMonth"><xsl:value-of select="../card/@month" /></xsl:with-param>
										<xsl:with-param name="CardYear"><xsl:value-of select="../card/@year" /></xsl:with-param>

			      			</xsl:call-template>
									
								</xsl:for-each>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>

			</RESULTSET>
		</FMPXMLRESULT>
	</xsl:template>
	
	<xsl:template name="bookings" xmlns="http://www.filemaker.com/fmpxmlresult"><!-- This complicated recursion is to appease MM -->
		<xsl:param name="Provider" />
		<xsl:param name="Result" />
		<xsl:param name="Mode" />
		<xsl:param name="ReservationID" />
		<xsl:param name="ReservationDateTime" />
		<xsl:param name="RoomType" />
		<xsl:param name="FullCount" />
		<xsl:param name="RoomCount" />
		<xsl:param name="Adult" />
		<!-- <xsl:param name="Child" /> -->
		<xsl:param name="DateIn" />
		<xsl:param name="DateOut" />
		<xsl:param name="CustomerFirstName" />
		<xsl:param name="CustomerSurname" />
		<xsl:param name="CustomerTelephone" />
		<xsl:param name="CustomerFax" />
		<xsl:param name="CustomerMobile" />
		<xsl:param name="CustomerEmail" />
		<xsl:param name="CustomerAddress" />
		<xsl:param name="PriceTotal" />
		<xsl:param name="Comment" />
		<xsl:param name="Agent" />
		<xsl:param name="CardName" />
		<xsl:param name="CardNumber" />
		<xsl:param name="CardMonth" />
		<xsl:param name="CardYear" />
		
		<ROW MODID="0" RECORDID="0">
			<COL><DATA><xsl:value-of select="$Provider"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$Result"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$Mode"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$ReservationID"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$ReservationDateTime"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$RoomType"/></DATA></COL>
			<!--<COL><DATA><xsl:value-of select="@count"/></DATA></COL>-->
			<COL><DATA><xsl:value-of select="$Adult"/></DATA></COL>
			<!-- <COL><DATA><xsl:value-of select="$Child"/></DATA></COL> -->
			<COL><DATA><xsl:value-of select="$DateIn"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$DateOut"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerFirstName"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerSurname"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerTelephone"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerFax"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerMobile"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerEmail"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CustomerAddress"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$PriceTotal"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$Comment"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$Agent"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CardName"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CardNumber"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CardMonth"/></DATA></COL>
			<COL><DATA><xsl:value-of select="$CardYear"/></DATA></COL>
		</ROW>
		
		<xsl:if test="$RoomCount &gt; 1">
			<xsl:call-template name="bookings">
				<xsl:with-param name="Provider"><xsl:value-of select="$Provider" /></xsl:with-param>
				<xsl:with-param name="Result"><xsl:value-of select="$Result" /></xsl:with-param>
				<xsl:with-param name="Mode"><xsl:value-of select="$Mode" /></xsl:with-param>
				<xsl:with-param name="ReservationID"><xsl:value-of select="$ReservationID" /></xsl:with-param>
				<xsl:with-param name="ReservationDateTime"><xsl:value-of select="$ReservationDateTime" /></xsl:with-param>
				<xsl:with-param name="RoomType"><xsl:value-of select="$RoomType" /></xsl:with-param>
				<xsl:with-param name="FullCount"><xsl:value-of select="$FullCount" /></xsl:with-param>
				<xsl:with-param name="RoomCount"><xsl:value-of select="$RoomCount - 1" /></xsl:with-param>
				<xsl:with-param name="Adult"><xsl:value-of select="$Adult" /></xsl:with-param>
				<!-- <xsl:with-param name="Child"><xsl:value-of select="$Child" /></xsl:with-param> -->
				<xsl:with-param name="DateIn"><xsl:value-of select="$DateIn" /></xsl:with-param>
				<xsl:with-param name="DateOut"><xsl:value-of select="$DateOut" /></xsl:with-param>
				<xsl:with-param name="CustomerFirstName"><xsl:value-of select="$CustomerFirstName" /></xsl:with-param>
				<xsl:with-param name="CustomerSurname"><xsl:value-of select="$CustomerSurname" /></xsl:with-param>
				<xsl:with-param name="CustomerTelephone"><xsl:value-of select="$CustomerTelephone" /></xsl:with-param>
				<xsl:with-param name="CustomerFax"><xsl:value-of select="$CustomerFax" /></xsl:with-param>
				<xsl:with-param name="CustomerMobile"><xsl:value-of select="$CustomerMobile" /></xsl:with-param>
				<xsl:with-param name="CustomerEmail"><xsl:value-of select="$CustomerEmail" /></xsl:with-param>
				<xsl:with-param name="CustomerAddress"><xsl:value-of select="$CustomerAddress" /></xsl:with-param>
				<xsl:with-param name="PriceTotal"><xsl:value-of select="$PriceTotal div $FullCount" /></xsl:with-param>
				<xsl:with-param name="Comment"><xsl:value-of select="$Comment" /></xsl:with-param>
				<xsl:with-param name="Agent"><xsl:value-of select="$Agent" /></xsl:with-param>
				<xsl:with-param name="CardName"><xsl:value-of select="$CardName" /></xsl:with-param>
				<xsl:with-param name="CardNumber"><xsl:value-of select="$CardNumber" /></xsl:with-param>
				<xsl:with-param name="CardMonth"><xsl:value-of select="$CardMonth" /></xsl:with-param>
				<xsl:with-param name="CardYear"><xsl:value-of select="$CardYear" /></xsl:with-param>
		 	</xsl:call-template>
	 	</xsl:if>	 	
	</xsl:template>
</xsl:stylesheet>

